from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class EasyGo(Player):
    """
    A player starts by defecting however will cooperate if at any point the
    opponent has defected.

    Names:

    - Easy Go: [Prison1998]_
    - Reverse Grudger (RGRIM): [Li2011]_
    - Fool Me Forever: [Harper2017]_
    """

    name = "EasyGo"
    classifier = {
        "memory_depth": float("inf"),  # Long memory
        "stochastic": False,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    @staticmethod
    def strategy(opponent: Player) -> Action:
        """Begins by playing D, then plays C for the remaining rounds if the
        opponent ever plays D."""
        if opponent.defections:
            return C
        return D